import Crypto.Algo.Algo;
import Crypto.CreateAlgorithmExecutorGenerator;

public class CryptoDriver {
    public static void main(String[] args) {
        CreateAlgorithmExecutorGenerator cl = new CreateAlgorithmExecutorGenerator();
        System.out.println("Encrypting using GHash");
        Algo gHashAlgo = cl.createAlgorithm("GHASH");
        String SampleStringForGHash = "G-HASH";
        System.out.println("Sample String before Encryption :: " + SampleStringForGHash);
        String encryptedGHash = gHashAlgo.encrypt(SampleStringForGHash);
        System.out.println("Encrypted String after encryption with GHash :: " + encryptedGHash);
        String decryptedGHash = gHashAlgo.decrypt(encryptedGHash);
        System.out.println("Decrypted String after encryption with GHash :: " + decryptedGHash);

        System.out.println("Encrypting using KHash");
        Algo kHashAlgo = cl.createAlgorithm("KHASH");
        String SampleStringForKHash = "K-HASH";
        System.out.println("Sample String before Encryption :: " + SampleStringForKHash);
        String encryptedKHash = kHashAlgo.encrypt(SampleStringForKHash);
        System.out.println("Encrypted String after encryption with KHash :: " + encryptedKHash);
        String decryptedKHash = kHashAlgo.decrypt(encryptedKHash);
        System.out.println("Decrypted String after encryption with KHash :: " + decryptedKHash);
    }
}
